*--- Data Environment Base Class
DEFINE CLASS deBase as DataEnvironment
	
	*--- Reference to Private Session Object
	oSession = .NULL.
	
	*--- Holds the name of the database of 
	*--- the cursor obejct
	cDatabase = ""
	
	*--- Choose the appropriate class for
	*--- either a private or default data
	*--- session
	cSession = ""
	
	*--- Init Event
	*--- Executes when the object is Instantiated
	PROCEDURE Init
		
		*--- Open a Data Session
		IF EMPTY(This.cSession)
			This.cSession = "pdsBase" && Default Data Session
		ENDIF
		
		This.oSession = CREATEOBJECT(This.cSession)
		
		*--- Change to the appropriate Data Session
		SET DATASESSION TO This.oSession.DataSessionID
		
		*--- Open Tables Accordingly
		IF This.AutoOpenTables
			This.OpenTables()
		ENDIF
		
		This.PostInitHook()
		
	ENDPROC
	
	*--- SelectAlias Method
	*--- Select the specified Alias
	PROCEDURE SelectAlias
		LPARAMETERS tcAlias
		LOCAL lcAlias, lnSessionID
		
		IF NOT EMPTY(tcalias)
			lcAlias = tcAlias
		ELSE
			*--- If an Alias wasn't received
			*--- then choose the InitialSelectedAlias
			lcAlias = This.GetAlias()
		ENDIF
		
		*--- Select the appropriate Database
		SET DATABASE TO (This.cDataBase)
		
		*--- Select the proper data session
		lnSessionID = This.GetSessionID()
		SET DATASESSION TO lnSessionID
		
		*--- Select the proper alias
		SELECT (lcAlias)
		
	ENDPROC
	
	*--- GetAlias Method
	*--- Returns the InitialSelectedAlias
	FUNCTION GetAlias(tcAlias as Character) as Character
		
		RETURN This.InitialSelectedAlias
		
	ENDFUNC
	
	*--- GetSessionID Method
	*--- Returns the Data Session ID for this BizObj
	FUNCTION GetSessionID() as Integer
		
		RETURN This.oSession.DataSessionID
		
	ENDFUNC
	
	*--- Destroy Event
	*--- Executed when the object is destroyed
	PROCEDURE Destroy()
		
		*--- close Tables Accordingly
		IF This.AutoCloseTables
			This.CloseTables()
		ENDIF
		
	ENDPROC
	
ENDDEFINE
